/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view;

import com.fb.tpe.Data;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.SplashScreen;
import java.awt.geom.Rectangle2D;

public class Splash {
    private static SplashScreen _splashScreen;
    private static Graphics2D _splashGraphics;
    private static Rectangle2D.Double _splashProgressArea;
    private static long _lastUpdateTime;

    static {
        _lastUpdateTime = 0L;
    }

    public static void updateSplashProgress(int amount) {
        int percent = Data.incSplashProgress(amount);
        if (Splash.isTimeToUpdate()) {
            Splash.setSplashProgress(percent);
        }
    }

    private static boolean isTimeToUpdate() {
        long newTime;
        boolean result = false;
        if (_lastUpdateTime == 0L) {
            _lastUpdateTime = System.currentTimeMillis();
            result = true;
        }
        if ((newTime = System.currentTimeMillis()) - _lastUpdateTime > 33L) {
            _lastUpdateTime = newTime;
            result = true;
        }
        return result;
    }

    public static void setSplashProgress(int percent) {
        if (_splashScreen != null && _splashScreen.isVisible()) {
            int x = (int)_splashProgressArea.getMinX();
            int y = (int)_splashProgressArea.getMinY();
            int wid = (int)_splashProgressArea.getWidth();
            int hgt = (int)_splashProgressArea.getHeight();
            int doneWidth = Math.round((float)(percent * wid) / 1000.0f);
            doneWidth = Math.max(0, Math.min(doneWidth, wid - 1));
            _splashGraphics.setPaint(Color.GREEN);
            _splashGraphics.fillRect(x, y, doneWidth, hgt);
            _splashScreen.update();
        }
    }

    public static void initSplashScreen() {
        _splashScreen = SplashScreen.getSplashScreen();
        if (_splashScreen != null) {
            Dimension dim = _splashScreen.getSize();
            int height = dim.height;
            int width = dim.width;
            _splashProgressArea = new Rectangle2D.Double((double)width * 0.33, (double)height * 0.89, (double)width * 0.43, 12.0);
            _splashGraphics = _splashScreen.createGraphics();
            _splashGraphics.setPaint(Color.WHITE);
            _splashGraphics.draw(_splashProgressArea);
            Splash.setSplashProgress(0);
        }
    }

    public static void pauseSplashProgress(int milliSec) {
        try {
            Thread.sleep(milliSec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void closeSplashScreen() {
        if (_splashScreen != null && _splashScreen.isVisible()) {
            _splashScreen.close();
        }
    }
}

