/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.ui.field;

import com.fb.tpe.model.data.BuffObject;
import com.fb.tpe.model.data.BuffTypes;
import com.fb.tpe.view.GUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class BuffCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = 6231010944395682538L;
    private BuffObject _currentObject;

    public void setCurrentObject(BuffObject currentObject) {
        this._currentObject = currentObject;
    }

    private String createToolTip(BuffObject buffObject) {
        String result = "";
        String buffColor = "purple";
        int buffType = buffObject.getBuffType();
        switch (buffType) {
            case 1: {
                buffColor = "green";
                break;
            }
            case 2: {
                buffColor = "red";
                break;
            }
            case 3: {
                buffColor = "purple";
            }
        }
        result = "<html><font color=\"black\"><b>" + buffObject.getBuffName() + "</b></font><br/>" + "<font color=\"" + "yellow" + "\">" + BuffTypes.BUFF_TYPES[buffObject.getBuffType()] + "</font><br>" + "<font color=\"" + buffColor + "\">" + buffObject.getBuffTip() + "</font></html>";
        return result;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
        if (value instanceof BuffObject) {
            BuffObject buffObject = (BuffObject)value;
            ImageIcon icon = buffObject.getBuffImage();
            result.setBorder(GUI.borderList);
            result.setToolTipText(this.createToolTip(buffObject));
            result.setBackground(GUI.colorBuffCell);
            if (buffObject.equals(this._currentObject)) {
                result.setBackground(GUI.colorBuffSelCell);
            }
            if (selected) {
                result.setBackground(GUI.colorBuffFocusCell);
            }
            result.setFont(GUI.fontSsB14);
            result.setIcon(icon);
            int iconGap = 5 + (GUI.DIM_ICON.width - icon.getIconWidth());
            result.setIconTextGap(iconGap);
            FontMetrics fontMetrics = result.getFontMetrics(result.getFont());
            int labelWidth = fontMetrics.stringWidth(result.getText());
            int width = GUI.DIM_ICON.width * 2 + labelWidth;
            int height = GUI.DIM_ICON.height;
            result.setPreferredSize(new Dimension(width, height));
            result.setMinimumSize(new Dimension(width, height));
            result.setMaximumSize(new Dimension(width, height));
        }
        return result;
    }
}

