/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.ui.field;

import com.fb.tpe.model.data.ItemObject;
import com.fb.tpe.model.data.ItemTypes;
import com.fb.tpe.view.GUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;

public class ItemCellRenderer
extends DefaultListCellRenderer {
    private static final long serialVersionUID = -7827182861378834095L;
    private ItemObject _currentObject;

    public void setCurrentObject(ItemObject currentObject) {
        this._currentObject = currentObject;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        JLabel result = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, selected, hasFocus);
        if (value instanceof ItemObject) {
            ItemObject itemObject = (ItemObject)value;
            ImageIcon icon = itemObject.getItemImage();
            result.setBorder(GUI.borderList);
            String toolTip = "<html><font color=\"white\"><b>" + itemObject.getItemName() + "</b></font><br/>" + "<font color=\"" + "yellow" + "\">" + ItemTypes.ITEM_TYPES[itemObject.getItemType()] + "</font></html>";
            result.setToolTipText(toolTip);
            result.setBackground(GUI.colorItemCell);
            if (itemObject.equals(this._currentObject)) {
                result.setBackground(GUI.colorItemSelCell);
            }
            if (selected) {
                result.setBackground(GUI.colorItemFocusCell);
            }
            result.setFont(GUI.fontSsB14);
            result.setIcon(icon);
            int iconGap = 5 + (GUI.DIM_ICON.width - icon.getIconWidth());
            result.setIconTextGap(iconGap);
            FontMetrics fontMetrics = result.getFontMetrics(result.getFont());
            int labelWidth = fontMetrics.stringWidth(result.getText());
            int width = GUI.DIM_ICON.width * 2 + labelWidth;
            int height = GUI.DIM_ICON.height;
            result.setPreferredSize(new Dimension(width, height));
            result.setMinimumSize(new Dimension(width, height));
            result.setMaximumSize(new Dimension(width, height));
        }
        return result;
    }
}

