/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.ui.panel;

import com.fb.tpe.Data;
import com.fb.tpe.model.data.BuffObject;
import com.fb.tpe.model.data.BuffObjectDAO;
import com.fb.tpe.model.data.BuffTypes;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.ui.field.DocumentInteger;
import com.fb.tpe.view.ui.field.PopupClickListener;
import com.fb.tpe.view.ui.panel.BuffPanelInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class BuffPanel
extends JPanel {
    private static final long serialVersionUID = -5647020921957087640L;
    private BuffPanelInterface _parent = null;
    private int _buffType = 0;
    private BuffObject _buffObject = null;
    private String _buffName = "";
    private int _maxTime = 10;
    private Color _color = null;
    JButton imageIcon;
    JLabel labelName;
    JTextField editTime;
    PopupClickListener popupBuff;
    ActionListener listenerIcon = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            BuffPanel.this.clickBuffPanel();
        }
    };
    DocumentListener listenerDocumentInteger = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent event) {
            BuffPanel.this.updateEditIntegerColor(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            BuffPanel.this.updateEditIntegerColor(event);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            BuffPanel.this.updateEditIntegerColor(event);
        }
    };
    FocusListener listenerFocusInteger = new FocusListener(){

        @Override
        public void focusGained(FocusEvent event) {
            BuffPanel.this.updateEditIntegerValue(event);
        }

        @Override
        public void focusLost(FocusEvent event) {
            BuffPanel.this.updateEditIntegerValue(event);
        }
    };

    public BuffPanel(BuffPanelInterface parent, int buffType, Color color) {
        this._parent = parent;
        this._buffType = buffType;
        this._color = color;
        this.initGUI();
    }

    public void setBuff(BuffObject buffObject, String buffTime) {
        this._buffObject = buffObject;
        ImageIcon buffIcon = buffObject.getBuffImage();
        String buffName = buffObject.getBuffName();
        int maxTime = buffObject.getBuffMaxTime();
        if (buffName == null) {
            buffName = "";
        }
        if (buffTime == null) {
            buffTime = "";
        }
        this._buffName = buffName;
        this._maxTime = maxTime;
        this.imageIcon.setIcon(buffIcon);
        if (!this._buffObject.equals(BuffObjectDAO.EMPTY_BUFF)) {
            this.labelName.setText(this._buffName);
            String toolTip = this.createToolTip(this._buffObject);
            this.labelName.setToolTipText(toolTip);
            this.imageIcon.setToolTipText(toolTip);
            this.popupBuff.setWikiTopic(this._buffName);
        } else {
            this.labelName.setText("");
            this.labelName.setToolTipText("No Buff");
            this.imageIcon.setToolTipText("No Buff");
            this.popupBuff.setWikiTopic(null);
        }
        this.editTime.setText(buffTime);
        if (buffTime.isEmpty()) {
            this.editTime.setEnabled(false);
        } else {
            this.editTime.setEnabled(true);
            int time = Data.getIntegerValue(buffTime);
            if (time >= 1 && time <= this._maxTime) {
                this.editTime.setForeground(GUI.colorEditGood);
            } else if (Data.getLimitAmounts()) {
                this.editTime.setForeground(GUI.colorEditBad);
            } else {
                this.editTime.setForeground(GUI.colorEditOver);
            }
        }
    }

    public BuffObject getBuffObject() {
        return this._buffObject;
    }

    public int getBuffTime() {
        String buffTime = this.editTime.getText();
        if (buffTime == null || buffTime.isEmpty()) {
            buffTime = "0";
        }
        return Integer.valueOf(buffTime);
    }

    private String createToolTip(BuffObject buffObject) {
        String result = "";
        String buffColor = "purple";
        int buffType = buffObject.getBuffType();
        switch (buffType) {
            case 1: {
                buffColor = "green";
                break;
            }
            case 2: {
                buffColor = "red";
                break;
            }
            case 3: {
                buffColor = "purple";
            }
        }
        result = "<html><font color=\"black\"><b>" + buffObject.getBuffName() + "</b></font><br/>" + "<font color=\"" + "yellow" + "\">" + BuffTypes.BUFF_TYPES[buffObject.getBuffType()] + "</font><br>" + "<font color=\"" + buffColor + "\">" + buffObject.getBuffTip() + "</font></html>";
        return result;
    }

    private void clickBuffPanel() {
        this._parent.clickBuffPanel((BuffPanel)this.imageIcon.getParent(), this._buffType);
    }

    private void updateEditIntegerColor(DocumentEvent event) {
        DocumentInteger document = (DocumentInteger)event.getDocument();
        JTextField sourceField = document.getParent();
        String strValue = sourceField.getText();
        int intValue = Data.getIntegerValue(strValue);
        if (intValue >= 0 && intValue <= this._maxTime) {
            sourceField.setForeground(GUI.colorEditGood);
        } else if (Data.getLimitAmounts()) {
            sourceField.setForeground(GUI.colorEditBad);
        } else {
            sourceField.setForeground(GUI.colorEditOver);
        }
        Data.setCharacterDirty();
    }

    private void updateEditIntegerValue(FocusEvent event) {
        JTextField sourceField = (JTextField)event.getSource();
        if (event.paramString().startsWith("FOCUS_GAINED")) {
            sourceField.selectAll();
        }
        if (event.paramString().startsWith("FOCUS_LOST")) {
            String strValue = sourceField.getText();
            if (strValue.isEmpty()) {
                strValue = "0";
            }
            if (Data.getLimitAmounts()) {
                int intValue = Data.getIntegerValue(strValue);
                if (intValue > this._maxTime || intValue == 0) {
                    sourceField.setText(Integer.toString(this._maxTime));
                }
            } else if (strValue.equals("0")) {
                sourceField.setText("1");
            }
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(this._color);
        this.setBorder(GUI.borderItemPanel);
        this.labelName = new JLabel("");
        this.labelName.setFont(GUI.fontSsP14);
        this.labelName.setOpaque(true);
        this.labelName.setBackground(this._color.brighter().brighter());
        this.labelName.setBorder(GUI.borderEmptyLR2px);
        FontMetrics fontMetrics = this.labelName.getFontMetrics(this.labelName.getFont());
        int labelHeight = fontMetrics.getHeight();
        int width = GUI.DIM_ICON.width;
        int height = labelHeight;
        this.labelName.setPreferredSize(new Dimension(width, height));
        this.labelName.setMinimumSize(new Dimension(width, height));
        this.labelName.setMaximumSize(new Dimension(width, height));
        this.labelName.setToolTipText("No Buff");
        this.imageIcon = new JButton(BuffObjectDAO.EMPTY_BUFF.getBuffImage());
        this.imageIcon.setBorder(GUI.borderIconPanel);
        this.imageIcon.setContentAreaFilled(false);
        this.imageIcon.setFocusPainted(false);
        this.imageIcon.setPreferredSize(GUI.DIM_ICON);
        this.imageIcon.setMinimumSize(GUI.DIM_ICON);
        this.imageIcon.setMaximumSize(GUI.DIM_ICON);
        this.imageIcon.setToolTipText("No Buff");
        this.imageIcon.addActionListener(this.listenerIcon);
        this.popupBuff = new PopupClickListener();
        this.imageIcon.addMouseListener(this.popupBuff);
        this.editTime = new JTextField("", 4);
        this.editTime.addFocusListener(this.listenerFocusInteger);
        this.editTime.setBorder(GUI.borderEditField);
        this.editTime.setBackground(GUI.colorEditBack);
        this.editTime.setDocument(new DocumentInteger(this.editTime, 4));
        this.editTime.getDocument().addDocumentListener(this.listenerDocumentInteger);
        this.editTime.setEnabled(false);
        this.editTime.setFont(GUI.fontSsB12);
        this.editTime.setOpaque(true);
        this.editTime.setHorizontalAlignment(4);
        this.add((Component)this.labelName, "North");
        this.add((Component)this.imageIcon, "Center");
        this.add((Component)this.editTime, "South");
    }
}

