/*
 * Decompiled with CFR 0.152.
 */
package com.fb.tpe.view.ui.panel;

import com.fb.tpe.Data;
import com.fb.tpe.model.data.ItemObject;
import com.fb.tpe.model.data.ItemObjectDAO;
import com.fb.tpe.model.data.ItemTypes;
import com.fb.tpe.model.data.PrefixObject;
import com.fb.tpe.model.data.PrefixObjectDAO;
import com.fb.tpe.view.GUI;
import com.fb.tpe.view.ui.field.DocumentInteger;
import com.fb.tpe.view.ui.field.PopupClickListener;
import com.fb.tpe.view.ui.panel.ItemPanelInterface;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ItemPanel
extends JPanel {
    private static final long serialVersionUID = 4375487786880306452L;
    private ItemPanelInterface _parent = null;
    private int _itemType = 0;
    private ItemObject _itemObject = null;
    private int _itemId = 0;
    private String _itemName = "";
    private int _prefixId = 0;
    private int _maxCount = 1;
    private Color _color = null;
    JPanel panelPrefix;
    JPanel panelItem;
    JLabel labelName;
    JTextField editCount;
    JButton buttonPrefix;
    JButton imageIcon;
    PopupClickListener popupItem;
    PopupClickListener popupPrefix;
    ActionListener listenerIcon = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            ItemPanel.this.clickItemPanel();
        }
    };
    ActionListener listenerPrefix = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent event) {
            ItemPanel.this.clickPrefix();
        }
    };
    DocumentListener listenerDocumentInteger = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent event) {
            ItemPanel.this.updateEditIntegerColor(event);
        }

        @Override
        public void removeUpdate(DocumentEvent event) {
            ItemPanel.this.updateEditIntegerColor(event);
        }

        @Override
        public void changedUpdate(DocumentEvent event) {
            ItemPanel.this.updateEditIntegerColor(event);
        }
    };
    FocusListener listenerFocusInteger = new FocusListener(){

        @Override
        public void focusGained(FocusEvent event) {
            ItemPanel.this.updateEditIntegerValue(event);
        }

        @Override
        public void focusLost(FocusEvent event) {
            ItemPanel.this.updateEditIntegerValue(event);
        }
    };

    public ItemPanel(ItemPanelInterface parent, int itemType, Color color) {
        this._parent = parent;
        this._itemType = itemType;
        this._color = color;
        this.initGUI();
    }

    public void setItem(ItemObject itemObject, int prefixId, String itemCount) {
        String toolTip;
        this._itemObject = itemObject;
        this._itemId = itemObject.getItemId();
        ImageIcon itemIcon = itemObject.getItemImage();
        String itemName = itemObject.getItemName();
        String prefixName = PrefixObjectDAO.getPrefixName(prefixId);
        int maxCount = Data.getLimitAmounts() ? itemObject.getItemMaxCount() : 999;
        if (itemName == null) {
            itemName = "";
        }
        if (itemCount == null) {
            itemCount = "";
        }
        this._itemName = itemName;
        this.imageIcon.setIcon(itemIcon);
        if (!this._itemObject.equals(ItemObjectDAO.getEmptyItem())) {
            this.labelName.setText(this._itemName);
            toolTip = "<html><font color=\"white\"><b>" + itemName + "</b></font><br/>" + "<font color=\"" + "yellow" + "\">" + ItemTypes.ITEM_TYPES[this._itemObject.getItemType()] + "</font></html>";
            this.labelName.setToolTipText(toolTip);
            this.imageIcon.setToolTipText(toolTip);
            this.popupItem.setWikiTopic(this._itemName);
        } else {
            this.labelName.setText(" ");
            this.labelName.setToolTipText("No Item");
            this.imageIcon.setToolTipText("No Item");
            this.popupItem.setWikiTopic(null);
        }
        this._prefixId = prefixId;
        if (this._prefixId != 0) {
            PrefixObject prefixObject = PrefixObjectDAO.getPrefixObjectById(prefixId);
            this.buttonPrefix.setText(prefixName);
            toolTip = "<html><font color=\"blue\"><b>" + prefixName + "</b></font><br/>" + prefixObject.getPrefixTip() + "</html>";
            this.buttonPrefix.setToolTipText(toolTip);
            this.popupPrefix.setWikiTopic("Prefix");
        } else {
            this.buttonPrefix.setText(" ");
            this.buttonPrefix.setToolTipText("No Prefix");
            this.popupPrefix.setWikiTopic(null);
        }
        this._maxCount = maxCount;
        this.editCount.setText(itemCount);
        if (itemCount.isEmpty()) {
            this.editCount.setEnabled(false);
        } else {
            this.editCount.setEnabled(true);
            int count = Data.getIntegerValue(itemCount);
            if (count >= 1 && count <= this._maxCount) {
                this.editCount.setForeground(GUI.colorEditGood);
            } else if (Data.getLimitAmounts()) {
                this.editCount.setForeground(GUI.colorEditBad);
            } else {
                this.editCount.setForeground(GUI.colorEditOver);
            }
        }
    }

    public ItemObject getItemObject() {
        return this._itemObject;
    }

    public int getItemId() {
        return this._itemId;
    }

    public int getItemCount() {
        String itemCount = this.editCount.getText();
        if (itemCount == null || itemCount.isEmpty()) {
            itemCount = "0";
        }
        return Integer.valueOf(itemCount);
    }

    public int getPrefixId() {
        return this._prefixId;
    }

    private void clickItemPanel() {
        this._parent.clickItemPanel((ItemPanel)this.imageIcon.getParent().getParent(), this._itemType);
    }

    private void clickPrefix() {
        if (!this._itemObject.equals(ItemObjectDAO.getEmptyItem()) && PrefixObjectDAO.isPrefixAllowed(this._itemObject)) {
            this._parent.clickPrefix((ItemPanel)this.imageIcon.getParent().getParent());
        }
    }

    private void updateEditIntegerColor(DocumentEvent event) {
        DocumentInteger document = (DocumentInteger)event.getDocument();
        JTextField sourceField = document.getParent();
        String strValue = sourceField.getText();
        int intValue = Data.getIntegerValue(strValue);
        if (intValue >= 0 && intValue <= this._maxCount) {
            sourceField.setForeground(GUI.colorEditGood);
        } else if (Data.getLimitAmounts()) {
            sourceField.setForeground(GUI.colorEditBad);
        } else {
            sourceField.setForeground(GUI.colorEditOver);
        }
        Data.setCharacterDirty();
    }

    private void updateEditIntegerValue(FocusEvent event) {
        JTextField sourceField = (JTextField)event.getSource();
        if (event.paramString().startsWith("FOCUS_GAINED")) {
            sourceField.selectAll();
        }
        if (event.paramString().startsWith("FOCUS_LOST")) {
            String strValue = sourceField.getText();
            if (strValue.isEmpty()) {
                strValue = "0";
            }
            if (Data.getLimitAmounts()) {
                int intValue = Data.getIntegerValue(strValue);
                if (intValue > this._maxCount || intValue == 0) {
                    sourceField.setText(Integer.toString(this._maxCount));
                }
            } else if (strValue.equals("0")) {
                sourceField.setText("1");
            }
        }
    }

    private void initGUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(this._color);
        this.setBorder(GUI.borderItemPanel);
        this.panelPrefix = new JPanel(new BorderLayout());
        this.panelPrefix.setOpaque(false);
        this.buttonPrefix = new JButton("");
        this.buttonPrefix.setFocusPainted(false);
        this.buttonPrefix.setFont(GUI.fontSsP12);
        this.buttonPrefix.setBackground(this._color.brighter());
        this.buttonPrefix.setBorder(GUI.borderLineGR1px);
        this.buttonPrefix.addActionListener(this.listenerPrefix);
        this.popupPrefix = new PopupClickListener();
        this.buttonPrefix.addMouseListener(this.popupPrefix);
        this.panelItem = new JPanel(new BorderLayout());
        this.panelItem.setOpaque(false);
        this.labelName = new JLabel("");
        this.labelName.setFont(GUI.fontSsP14);
        this.labelName.setOpaque(true);
        this.labelName.setBackground(this._color.brighter().brighter());
        this.labelName.setBorder(GUI.borderEmptyLR2px);
        FontMetrics fontMetrics = this.labelName.getFontMetrics(this.labelName.getFont());
        int labelHeight = fontMetrics.getHeight();
        int width = GUI.DIM_ICON.width;
        int height = labelHeight;
        this.labelName.setPreferredSize(new Dimension(width, height));
        this.labelName.setMinimumSize(new Dimension(width, height));
        this.labelName.setMaximumSize(new Dimension(width, height));
        this.labelName.setToolTipText("No Item");
        this.imageIcon = new JButton(ItemObjectDAO.getEmptyItem().getItemImage());
        this.imageIcon.setBorder(GUI.borderIconPanel);
        this.imageIcon.setContentAreaFilled(false);
        this.imageIcon.setFocusPainted(false);
        this.imageIcon.setPreferredSize(GUI.DIM_ICON);
        this.imageIcon.setMinimumSize(GUI.DIM_ICON);
        this.imageIcon.setMaximumSize(GUI.DIM_ICON);
        this.imageIcon.setToolTipText("No Item");
        this.imageIcon.addActionListener(this.listenerIcon);
        this.popupItem = new PopupClickListener();
        this.imageIcon.addMouseListener(this.popupItem);
        this.editCount = new JTextField("", 4);
        this.editCount.addFocusListener(this.listenerFocusInteger);
        this.editCount.setBorder(GUI.borderEditField);
        this.editCount.setBackground(GUI.colorEditBack);
        this.editCount.setDocument(new DocumentInteger(this.editCount, 3));
        this.editCount.getDocument().addDocumentListener(this.listenerDocumentInteger);
        this.editCount.setEnabled(false);
        this.editCount.setFont(GUI.fontSsB12);
        this.editCount.setOpaque(true);
        this.editCount.setHorizontalAlignment(4);
        this.add((Component)this.panelPrefix, "North");
        this.panelPrefix.add((Component)this.buttonPrefix, "Center");
        this.add((Component)this.panelItem, "Center");
        this.panelItem.add((Component)this.labelName, "North");
        this.panelItem.add((Component)this.imageIcon, "Center");
        this.panelItem.add((Component)this.editCount, "South");
    }
}

