/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria;

import com.su.slytherin.terraria.Copyable;
import com.su.slytherin.terraria.player.Sizeable;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class Razdor {
    private Razdor() {
    }

    public static <T extends Copyable<T>> T copy(T object) {
        Copyable copy = (Copyable)object.copy();
        assert (copy != object && copy.equals(object)) : "Copyable copy failed";
        return (T)copy;
    }

    public static <T extends Copyable<T>> ArrayList<T> copyList(List<T> list) {
        int size = list.size();
        ArrayList<Copyable> copy = new ArrayList<Copyable>(size);
        int index = 0;
        while (index < size) {
            copy.add((Copyable)((Copyable)list.get(index)).copy());
            assert (copy.get(index) != list.get(index)) : "List copy not copying";
            ++index;
        }
        assert (copy.equals(list)) : "List copy failed";
        return copy;
    }

    public static <T extends Copyable<T>> void copyList(List<T> src, ArrayList<T> dest) {
        int size = src.size();
        dest.clear();
        dest.ensureCapacity(size);
        int i = 0;
        while (i < size) {
            dest.add((Copyable)((Copyable)src.get(i)).copy());
            assert (dest.get(i) != src.get(i)) : "List copy not copying";
            ++i;
        }
        assert (dest.equals(src)) : "List copy failed";
        dest.trimToSize();
    }

    public static <T> T requireReal(T obj) {
        if (obj == null) {
            throw new NullPointerException();
        }
        return obj;
    }

    public static <T> T requireReal(T obj, String message) {
        if (obj == null) {
            throw new NullPointerException(message);
        }
        return obj;
    }

    public static <T extends Sizeable> T requireSize(T inv, int size) {
        int current = inv.size();
        if (current != size) {
            throw new IllegalArgumentException("Inventory size must be " + size + ", was " + current);
        }
        return inv;
    }

    public static void close(Closeable ... closeables) {
        Closeable[] closeableArray = closeables;
        int n = closeables.length;
        int n2 = 0;
        while (n2 < n) {
            Closeable closeable = closeableArray[n2];
            if (closeable != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n2;
        }
    }
}

