/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria.player;

import com.su.slytherin.terraria.ArrayIterator;
import com.su.slytherin.terraria.Razdor;
import com.su.slytherin.terraria.player.Item;
import com.su.slytherin.terraria.player.ItemInv;
import java.util.Arrays;
import java.util.Iterator;

public final class Equipment
implements ItemInv {
    private final Item[] _items;
    private final int _size;

    private Equipment(int size) {
        this._size = size;
        this._items = new Item[this._size];
        Arrays.fill(this._items, Item.EMPTY);
    }

    private Equipment(Item[] copy) {
        this._size = copy.length;
        this._items = copy;
    }

    @Override
    public Item getItem(int position) {
        this.checkBounds(position);
        return this._items[position];
    }

    @Override
    public Equipment setItem(int position, Item item) {
        this.checkBounds(position);
        this._items[position] = Razdor.requireReal(item);
        return this;
    }

    @Override
    public Equipment setItem(int position, String itemName) {
        return this.setItem(position, Item.of(itemName, 0));
    }

    public static ItemInv create(int size) {
        Equipment equipment = new Equipment(size);
        return equipment;
    }

    public static ItemInv createArmor() {
        return Equipment.create(3);
    }

    public static ItemInv createAccessories() {
        return Equipment.create(5);
    }

    public static ItemInv createSocial() {
        return Equipment.create(3);
    }

    private void checkBounds(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Equipment index is out of bounds: " + index + " must be less than size: " + this._size);
        }
    }

    @Override
    public Equipment clear() {
        Arrays.fill(this._items, Item.EMPTY);
        return this;
    }

    @Override
    public Equipment copy() {
        Equipment copy = new Equipment(Arrays.copyOf(this._items, this._size));
        assert (copy.equals(this)) : "Equipment copy failed";
        return copy;
    }

    @Override
    public boolean equals(Object object) {
        boolean result = false;
        if (object == this) {
            result = true;
        } else if (object == null || !(object instanceof ItemInv)) {
            result = false;
        } else if (this.getClass() == object.getClass()) {
            Equipment equipment = (Equipment)object;
            result = this._size == equipment._size && Arrays.equals(this._items, equipment._items);
        } else {
            ItemInv itemInv = (ItemInv)object;
            if (this._size != itemInv.size()) {
                result = false;
            } else {
                int i = 0;
                while (i < this._size) {
                    if (!this._items[i].equals(itemInv.getItem(i))) {
                        return false;
                    }
                    ++i;
                }
                result = true;
            }
        }
        return result;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        return (31 + this._size) * 31 + Arrays.hashCode(this._items);
    }

    @Override
    public Iterator<Item> iterator() {
        return ArrayIterator.wrap(Arrays.copyOf(this._items, this._size));
    }

    @Override
    public int size() {
        return this._size;
    }

    public String toString() {
        return "Equipment [size=" + this._size + ", items=" + Arrays.toString(this._items) + "]";
    }
}

