/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria.player;

import com.fb.tpe.model.data.ItemObjectDAO;
import com.su.slytherin.terraria.Razdor;

public final class Item {
    public static final Item EMPTY = new Item(0, 0);
    private final String _itemName;
    private final int _itemId;
    private final char _prefix;
    private final int _hash;

    private Item(int itemId, int prefix) {
        this._itemId = itemId;
        this._itemName = ItemObjectDAO.getItemNameById(this._itemId);
        this._prefix = Item.clamp(prefix);
        this._hash = this._itemName.hashCode() * 31 + this._prefix;
    }

    public static Item of(int netId, int prefix) {
        return new Item(netId, (char)prefix);
    }

    public static Item of(String itemName, int prefix) {
        Razdor.requireReal(itemName, "Item name can't be null.");
        return new Item(ItemObjectDAO.getItemIdByName(itemName), (char)prefix);
    }

    public int getItemId() {
        return this._itemId;
    }

    public String getItemName() {
        return this._itemName;
    }

    public int getPrefix() {
        return this._prefix;
    }

    private static char clamp(int c) {
        return (char)Math.min(c, 255);
    }

    public boolean equals(Object obj) {
        boolean result = false;
        Item comparator = (Item)obj;
        result = this == obj ? true : (obj == null || this.getClass() != obj.getClass() ? false : this._hash == comparator._hash && this._prefix == comparator._prefix && this._itemId == comparator._itemId);
        return result;
    }

    public int hashCode() {
        return this._hash;
    }

    public String toString() {
        return "Item [id=" + this._itemId + ", name=" + this._itemName + ", prefix=" + this._prefix + "]";
    }
}

