/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria.player;

import com.su.slytherin.terraria.Razdor;
import com.su.slytherin.terraria.TerrReader;
import com.su.slytherin.terraria.player.ParseException;
import com.su.slytherin.terraria.player.Player;
import com.su.slytherin.terraria.player.PlayerCrypt;
import com.su.slytherin.terraria.player.PlayerReader;
import com.su.slytherin.terraria.player.PlayerWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class PlayerIO {
    static final Set<Integer> KNOWN_VERSIONS;

    static {
        Integer[] knownVersions = new Integer[]{2, 3, 6, 9, 10, 11, 12, 15, 17, 20, 22, 36, 37, 39};
        HashSet<Integer> s = new HashSet<Integer>(Arrays.asList(knownVersions));
        KNOWN_VERSIONS = Collections.unmodifiableSet(s);
    }

    private PlayerIO() {
        throw new AssertionError((Object)"WHAT? STOP THAT!");
    }

    public static Player loadPlayer(File input) throws IOException, ParseException {
        TerrReader reader = PlayerIO.decryptFromFile(input);
        return PlayerIO.parsePlayer(reader);
    }

    private static TerrReader decryptFromFile(File input) throws FileNotFoundException, IOException {
        InputStream cis = PlayerCrypt.getCipherInput(input);
        ByteBuffer buffer = ByteBuffer.allocate((int)input.length());
        int bufSize = 8192;
        byte[] biteArray = new byte[8192];
        try {
            int count;
            while ((count = cis.read(biteArray)) != -1) {
                buffer.put(biteArray, 0, count);
            }
        }
        catch (Throwable throwable) {
            Razdor.close(cis);
            throw throwable;
        }
        Razdor.close(cis);
        buffer.rewind();
        return new TerrReader(buffer);
    }

    public static Player parsePlayer(TerrReader reader) throws ParseException {
        Player result;
        try {
            PlayerReader playerReader = new PlayerReader(reader);
            result = playerReader.readPlayer();
        }
        catch (Exception e) {
            throw new ParseException("Failed to parse Player!", e);
        }
        return result;
    }

    public static byte[] encodePlayer(Player player) {
        PlayerWriter writer = new PlayerWriter(player);
        return writer.writePlayer();
    }

    private static void encryptToFile(File output, byte[] data) throws FileNotFoundException, IOException {
        OutputStream cos = PlayerCrypt.getCipherOutput(output);
        try {
            cos.write(data, 0, data.length);
        }
        catch (Throwable throwable) {
            Razdor.close(cos);
            throw throwable;
        }
        Razdor.close(cos);
    }

    public static void writePlayer(File output, Player player) throws IOException {
        byte[] encodedPlayer = PlayerIO.encodePlayer(player);
        PlayerIO.encryptToFile(output, encodedPlayer);
    }

    public static void writePlayerDecrypted(File output, Player player) throws IOException {
        byte[] playbytes = PlayerIO.encodePlayer(player);
        PlayerIO.writeToFile(output, playbytes);
    }

    private static void writeToFile(File output, byte[] data) throws FileNotFoundException, IOException {
        FileOutputStream cos = new FileOutputStream(output);
        try {
            ((OutputStream)cos).write(data, 0, data.length);
        }
        catch (Throwable throwable) {
            Razdor.close(cos);
            throw throwable;
        }
        Razdor.close(cos);
    }
}

