/*
 * Decompiled with CFR 0.152.
 */
package com.su.slytherin.terraria.player;

import com.su.slytherin.terraria.Copyable;
import com.su.slytherin.terraria.Razdor;

public final class SpawnPoint
implements Copyable<SpawnPoint> {
    private String _worldName;
    private int _spawnX;
    private int _spawnY;
    private int _worldId;

    private SpawnPoint(String worldName, int spawnX, int spawnY, int worldID) {
        this._worldName = Razdor.requireReal(worldName, "SpawnPoint's world name can't be null.");
        this._spawnX = SpawnPoint.requireMinimum(spawnX, 0, "SpawnPoint's x-coordinate must be >=0!");
        this._spawnY = spawnY;
        this._worldId = worldID;
    }

    public static SpawnPoint of(String worldName, int spawnX, int spawnY, int worldID) {
        return new SpawnPoint(worldName, spawnX, spawnY, worldID);
    }

    public int getX() {
        return this._spawnX;
    }

    public SpawnPoint setX(int spawnX) {
        this._spawnX = spawnX;
        return this;
    }

    public int getY() {
        return this._spawnY;
    }

    public SpawnPoint setY(int spawnY) {
        this._spawnY = spawnY;
        return this;
    }

    public int getWorldID() {
        return this._worldId;
    }

    public SpawnPoint setWorldID(int worldID) {
        this._worldId = worldID;
        return this;
    }

    public String getWorldName() {
        return this._worldName;
    }

    public SpawnPoint setWorldName(String worldName) {
        this._worldName = Razdor.requireReal(worldName, "SpawnPoint's world name can't be null.");
        return this;
    }

    private static int requireMinimum(int coord, int min, String message) {
        int result = coord;
        if (coord < min) {
            throw new IllegalArgumentException(message);
        }
        result = coord;
        return result;
    }

    @Override
    public SpawnPoint copy() {
        SpawnPoint copy = new SpawnPoint(this._worldName, this._spawnX, this._spawnY, this._worldId);
        assert (copy.equals(this)) : "SpawnPoint copy failed";
        return copy;
    }

    public boolean equals(Object object) {
        boolean result = false;
        if (this == object) {
            result = true;
        } else if (object == null || object.getClass() != this.getClass()) {
            result = false;
        } else {
            SpawnPoint spawnPoint = (SpawnPoint)object;
            result = this._worldId != spawnPoint._worldId || this._spawnX != spawnPoint._spawnX || this._spawnY != spawnPoint._spawnY ? false : this._worldName.equals(spawnPoint._worldName);
        }
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._worldId;
        result = 31 * result + this._spawnX;
        result = 31 * result + this._spawnY;
        result = 31 * result + this._worldName.hashCode();
        return result;
    }

    public String toString() {
        return String.format("Spawn for %s (ID %d): (%d, %d)", this._worldName, this._worldId, this._spawnX, this._spawnY);
    }
}

